package com.hero.objects.powers;

import java.math.BigDecimal;
import java.text.NumberFormat;

import org.jdom.Element;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;
import com.hero.objects.modifiers.Modifier;
import com.hero.util.Rounder;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class DensityIncrease extends Power {

	private static String xmlID = "DENSITYINCREASE";

	public DensityIncrease(Element root) {
		super(root, DensityIncrease.xmlID);
	}

	@Override
	public String getColumn2Output() {
		String ret = getAlias() + " (" + getDamageDisplay() + ")";
		if (getName().trim().length() > 0) {
			ret = "<i>" + getName() + ":</i>  " + ret;
		}
		if ((getInput() != null) && (getInput().trim().length() > 0)) {
			ret += ":  " + getInput();
		}
		String adderString = getAdderString();
		if (adderString.trim().length() > 0) {
			ret += ", " + adderString;
		}
		ret += getModifierString();
		if ((getEndUsage() > 0)
				&& (GenericObject.findObjectByID(HeroDesigner.getActiveHero()
						.getPowers(), "ENDURANCERESERVE") != null)
				&& (GenericObject.findObjectByID(getAllAssignedModifiers(),
						"ENDRESERVEOREND") == null)
				&& !HeroDesigner.getInstance().getPrefs().useWG()) {
			if (getUseENDReserve()) {
				ret += " (uses END Reserve)";
			} else {
				ret += " (uses Personal END)";
			}
		}
		return ret;
	}

	@Override
	public String getDamageDisplay() {
		long g = Rounder
				.roundHalfUp(HeroDesigner.getActiveHero().getWeight() * 453.5924);
		if (HeroDesigner.getInstance().getPrefs().isMetric()) {
			g = HeroDesigner.getActiveHero().getWeight() * 1000;
		}
		g = g
				* (long) Math.pow(massMultiplier,
						((double) getLevels() / (double) massMultiplierLevels));
		BigDecimal wght = new BigDecimal(g / 100000d);
		wght = wght.setScale(0, BigDecimal.ROUND_HALF_UP);
		wght = new BigDecimal(wght.doubleValue() * 100);
		wght = wght.setScale(0, BigDecimal.ROUND_HALF_UP);

		String weight = NumberFormat.getInstance().format(wght.doubleValue())
				+ " kg mass";
		BigDecimal st = new BigDecimal(getStrIncrease()
				* Rounder.roundHalfUp((double) getLevels()
						/ (double) strIncreaseLevels));
		st = st.setScale(0, BigDecimal.ROUND_HALF_UP);
		String str = "+" + st.toString() + " STR";
		int pded = (int) Rounder.roundHalfUp(getPdIncrease()
				* Rounder.roundHalfUp((double) getLevels()
						/ (double) getPdIncreaseLevels()));
			
		String def = "+" + pded + " PD/ED";
		if (GenericObject.findObjectByID(getAssignedModifiers(),
				"NODEFINCREASE") != null) {
			GenericObject mod = GenericObject.findObjectByID(
					getAssignedModifiers(), "NODEFINCREASE");
			if (mod.getSelectedOption() == null) {

			} else if (mod.getSelectedOption().getXMLID().equals("PD")) {
				pded = (int) Rounder.roundHalfUp(getEdIncrease()
						* Rounder.roundHalfUp((double) getLevels()
								/ (double) getEdIncreaseLevels()));
				def = "+" + pded + " ED";
			} else if (mod.getSelectedOption().getXMLID().equals("ED")) {
				def = "+" + pded + " PD";
			} else if (mod.getSelectedOption().getXMLID().equals("PDED")) {
				def = null;
			}
		}
		int kb = (int) Rounder.roundHalfUp(kbIncrease
				* Rounder.roundHalfUp((double) getLevels()
						/ (double) kbIncreaseLevels));
		String kbdec = "";
		if (HeroDesigner.getActiveTemplate().is6E()) {
			kbdec = (kb < 0 ? "" : "+") + (kb*2) + "m KB";
		} else {
			kbdec = (kb < 0 ? "" : "+") + kb + "\" KB";
		}

		String ret = weight + ", " + str + ", "
				+ (def != null ? def + ", " : "") + kbdec;
		return ret;
	}

	@Override
	public double getEdIncrease() {
		boolean pd = true;
		boolean ed = true;
		GenericObject mod = findObjectByID(getAssignedModifiers(), "NODEFINCREASE");
		if (mod != null) {
			if (mod.getSelectedOption() != null) {
				if (mod.getSelectedOption().getXMLID().equals("PDED")) {
					pd = false;
					ed = false;
				} else if (mod.getSelectedOption().getXMLID().equals("PD")) {
					pd = false;
				} else if (mod.getSelectedOption().getXMLID().equals("ED")) {
					ed = false;
				}
			}
		}
		if (!ed) return 0;
		return super.getEdIncrease();
	}

	@Override
	public double getPdIncrease() {
		boolean pd = true;
		boolean ed = true;
		GenericObject mod = findObjectByID(getAssignedModifiers(), "NODEFINCREASE");
		if (mod != null) {
			if (mod.getSelectedOption() != null) {
				if (mod.getSelectedOption().getXMLID().equals("PDED")) {
					pd = false;
					ed = false;
				} else if (mod.getSelectedOption().getXMLID().equals("PD")) {
					pd = false;
				} else if (mod.getSelectedOption().getXMLID().equals("ED")) {
					ed = false;
				}
			}
		}
		if (!pd) return 0;
		return super.getPdIncrease();
	}

	@Override
	public int getLevels() {
		if (super.getLevels() > 50) {
			return 50;
		} else {
			return super.getLevels();
		}
	}

	@Override
	public double getStrIncrease() {
		if (GenericObject.findObjectByID(getAllAssignedModifiers(),
				"NOSTRINCREASE") != null) {
			return 0;
		}
		return strIncrease;
	}

}